#include "DataSimState.h"

namespace DataTypes
{

DataSimState::DataSimState()
{
}

DataSimState::DataSimState(bool initialized,
	bool syncmode,
	bool flagsync,
	bool stepmode,
	bool stepflag,
	bool broadcastflag,
	float stepsize,
	double lastTime,
	double lastSync,
	double syncwait,
	int itercount,
	Vector3f worldgravity,
	float worldhardness,
	float worldbounciness,
	int stepsperiteration,
	bool fastmode,
	bool autoadjustmode,
	float lastaverageelapsedstep,
	int lastaveragestepsperiteration)
{
	this->initialized = initialized;
	this->syncmode = syncmode;
	this->flagsync = flagsync;
	this->stepmode = stepmode;
	this->stepflag = stepflag;
	this->broadcastflag = broadcastflag;
	this->stepsize = stepsize;
	this->lastTime = lastTime;
	this->lastSync = lastSync;
	this->itercount = itercount;
	this->worldgravity = worldgravity;
	this->worldhardness = worldhardness;
	this->worldbounciness = worldbounciness;
	this->stepsperiteration = stepsperiteration;
	this->fastmode = fastmode;
	this->autoadjustmode = autoadjustmode;
	this->lastaverageelapsedstep = lastaverageelapsedstep;
	this->lastaveragestepsperiteration = lastaveragestepsperiteration;
}

DataSimState::~DataSimState()
{
}

bool DataSimState::GetInitialized()
{
	return initialized;
}

bool DataSimState::GetSyncMode()
{
	return syncmode;
}

bool DataSimState::GetFlagSync()
{
	return flagsync;
}

bool DataSimState::GetStepMode()
{
	return stepmode;
}

bool DataSimState::GetStepflag()
{
	return stepflag;
}

bool DataSimState::GetBroadcastflag()
{
	return broadcastflag;
}

float DataSimState::GetStepSize()
{
	return stepsize;
}

double DataSimState::GetLastTime()
{
	return lastTime;
}

double DataSimState::GetLastSync()
{
	return lastSync;
}

double DataSimState::GetSyncWait()
{
	return syncwait;
}

int DataSimState::GetIterCount()
{
	return itercount;
}

Vector3f DataSimState::GetWorldGravity()
{
	return worldgravity;
}

float DataSimState::GetWorldHardness()
{
	return worldhardness;
}

float DataSimState::GetWorldBounciness()
{
	return worldbounciness;
}

int DataSimState::GetStepsPerIteration()
{
	return stepsperiteration;
}

bool DataSimState::GetFastMode()
{
	return fastmode;
}

bool DataSimState::GetAutoAdjustMode()
{
	return autoadjustmode;
}
float DataSimState::GetLastAverageElapsedStep()
{
	return lastaverageelapsedstep;
}
int DataSimState::GetLastAverageStepsPerIteration()
{
	return lastaveragestepsperiteration;
}


string DataSimState::ToString()
{
	stringstream stepsizestream, lastTimestream, lastSyncstream,syncwaitstream,itercountstream, worldhardnessstream, worldbouncinessstream, stepsperiterationstream, lastaverageelapsedstepstream, lastaveragestepsperiterationstream;
	stepsizestream<<stepsize;
	lastTimestream<<lastTime;
	lastSyncstream<<lastSync;
	syncwaitstream<<syncwait;
	itercountstream<<itercount;
	worldhardnessstream<<worldhardness;
	worldbouncinessstream<<worldbounciness;
	stepsperiterationstream<<stepsperiteration;
	lastaverageelapsedstepstream<<lastaverageelapsedstep;
	lastaveragestepsperiterationstream<<lastaveragestepsperiteration; 
	
	/*booleans*/
	string initializedstr,syncmodestr, flagsyncstr,stepmodestr, stepflagstr,broadcastflagstr, fastmodestr, autoadjustmodestr;
	initializedstr = "<Initialized>";
	syncmodestr = "<Sync_Mode>";
	flagsyncstr = "<Flag_Sync>";
	stepmodestr = "<Step_Mode>";
	stepflagstr = "<Step_Flag>";
	broadcastflagstr = "<Broadcast_Flag>";
	fastmodestr = "<Fast_Mode>";
	autoadjustmodestr = "<AutoAdjust_Mode>";
	if (initialized)
		initializedstr += "true";
	else
		initializedstr += "false";
	if (syncmode)
		syncmodestr += "true";
	else
		syncmodestr += "false";
	if (flagsync)
		flagsyncstr += "true";
	else
		flagsyncstr += "false";
	if (stepmode)
		stepmodestr += "true";
	else
		stepmodestr += "false";
	if (stepflag)
		stepflagstr += "true";
	else
		stepflagstr += "false";
	if (broadcastflag)
		broadcastflagstr += "true";
	else
		broadcastflagstr += "false";
	if (fastmode)
		fastmodestr += "true";
	else
		fastmodestr += "false";
	if (autoadjustmode)
		autoadjustmodestr += "true";
	else
		autoadjustmodestr += "false";
			
	initializedstr += "</Initialized>";
	syncmodestr += "</Sync_Mode>";
	flagsyncstr += "</Flag_Sync>";
	stepmodestr += "</Step_Mode>";
	stepflagstr += "</Step_Flag>";
	broadcastflagstr += "</Broadcast_Flag>";
	fastmodestr += "</Fast_Mode>";
	autoadjustmodestr += "</AutoAdjust_Mode>";
	string stepsizestr, lastTimestr, lastSyncstr,syncwaitstr,itercountstr, worldhardnessstr, worldbouncinessstr, stepsperiterationstr, lastaverageelapsedstepstr, lastaveragestepsperiterationstr;
	stepsizestr = "<Step_Size>" + stepsizestream.str()+"</Step_Size>";
	lastTimestr = "<Last_Time>" + lastTimestream.str()+"</Last_Time>";
	lastSyncstr = "<Last_Sync>" + lastSyncstream.str()+"</Last_Sync>";
	syncwaitstr = "<Sync_Wait>" + syncwaitstream.str()+"</Sync_Wait>";
	itercountstr = "<Iter_Count>" + itercountstream.str()+"</Iter_Count>";
	worldhardnessstr = "<World_Hardness>" + worldhardnessstream.str()+"</World_Hardness>";
	worldbouncinessstr = "<World_Bounciness>" + worldbouncinessstream.str()+"</World_Bounciness>";
	stepsperiterationstr = "<Steps_Per_Iteration>" + stepsperiterationstream.str()+"</Steps_Per_Iteration>";
	lastaverageelapsedstepstr = "<Last_Average_Elapsed_Steps>" + lastaverageelapsedstepstream.str()+"</Last_Average_Elapsed_Steps>";
	lastaveragestepsperiterationstr = "<Last_Average_Steps_Per_Iteration>" + lastaveragestepsperiterationstream.str()+"</Last_Average_Steps_Per_Iteration>";
	string toreturn = "<Simulation_State>" +initializedstr+syncmodestr+flagsyncstr+stepmodestr+stepflagstr+broadcastflagstr+stepsizestr+lastTimestr+lastSyncstr+syncwaitstr+itercountstr+autoadjustmodestr+"<Gravity>"+worldgravity.ToString("Gravity_X","Gravity_Y","Gravity_Z")+"</Gravity>"+worldhardnessstr+worldbouncinessstr+stepsperiterationstr+fastmodestr+lastaverageelapsedstepstr+lastaveragestepsperiterationstr+"</Simulation_State>";
	return toreturn;
}

}
